from typing import Optional
import c4d

doc: c4d.documents.BaseDocument  # The active document
op: Optional[c4d.BaseObject]  # The active object, None if unselected



def main() -> None:
    def tool() -> c4d.plugins.BasePlugin:
        return c4d.plugins.FindPlugin(doc.GetAction(), c4d.PLUGINTYPE_TOOL)

    def object() -> Optional[c4d.BaseObject]:
        return doc.GetActiveObject()

    def tag() -> Optional[c4d.BaseTag]:
        return doc.GetActiveTag()

    def renderdata() -> c4d.documents.RenderData:
        return doc.GetActiveRenderData()

    def prefs(id) -> c4d.plugins.BasePlugin:
        return c4d.plugins.FindPlugin(id, c4d.PLUGINTYPE_PREFS)

    c4d.CallCommand(12161) # レンダリング設定を編集...
    renderdata()[c4d.RDATA_RENDERENGINE] = 1036219
    c4d.CallCommand(12392)


if __name__ == '__main__':
    main()
    c4d.EventAdd()